/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.worldgen.namegen.BiomeNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.CustomNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MixedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MrPorkNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.RomanNumber;
import net.blay09.mods.waystones.worldgen.namegen.SequencedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.TemplateNameGenerator;
import net.minecraft.class_18;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NameGeneratorManager
extends class_18 {
    private static final String DATA_NAME = "waystones_NameGenerator";
    private static final String USED_NAMES = "UsedNames";
    private static final NameGeneratorManager clientStorageCopy = new NameGeneratorManager();
    private final Set<String> usedNames = Sets.newHashSet();

    private NameGenerator getNameGenerator(NameGenerationMode nameGenerationMode) {
        TemplateNameGenerator randomGenerator = new TemplateNameGenerator(WaystonesConfig.getActive().worldGen.nameGenerationTemplate).with("MrPork", new MrPorkNameGenerator()).with("Biome", new BiomeNameGenerator());
        switch (nameGenerationMode) {
            case MIXED: {
                return new MixedNameGenerator(randomGenerator, new CustomNameGenerator(false, this.usedNames));
            }
            case RANDOM_ONLY: {
                return randomGenerator;
            }
            case PRESET_ONLY: {
                return new CustomNameGenerator(true, this.usedNames);
            }
        }
        return new SequencedNameGenerator(new CustomNameGenerator(false, this.usedNames), randomGenerator);
    }

    public synchronized class_2561 getName(class_1936 level, Waystone waystone, class_5819 rand, NameGenerationMode nameGenerationMode) {
        NameGenerator nameGenerator = this.getNameGenerator(nameGenerationMode);
        class_2561 originalName = nameGenerator.generateName(level, waystone, rand).orElse((class_2561)class_2561.method_43473());
        class_2561 name = this.resolveDuplicate(originalName);
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(waystone, name);
        Balm.getEvents().fireEvent((Object)event);
        name = event.getName();
        this.usedNames.add(name.getString());
        this.method_80();
        return name;
    }

    private class_2561 resolveDuplicate(class_2561 name) {
        class_2561 tryName = name;
        int i = 1;
        while (this.usedNames.contains(tryName.getString())) {
            tryName = name.method_27661().method_27693(" " + RomanNumber.toRoman(i));
            ++i;
        }
        return tryName;
    }

    public static NameGeneratorManager load(class_2487 compound, class_7225.class_7874 provider) {
        NameGeneratorManager nameGenerator = new NameGeneratorManager();
        class_2499 tagList = compound.method_10554(USED_NAMES, 8);
        for (class_2520 tag : tagList) {
            nameGenerator.usedNames.add(tag.method_10714());
        }
        return nameGenerator;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        class_2499 tagList = new class_2499();
        for (String entry : this.usedNames) {
            tagList.add((Object)class_2519.method_23256((String)entry));
        }
        compound.method_10566(USED_NAMES, (class_2520)tagList);
        return compound;
    }

    public static NameGeneratorManager get(@Nullable MinecraftServer server) {
        if (server != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            return (NameGeneratorManager)Objects.requireNonNull(overworld).method_17983().method_17924(new class_18.class_8645(NameGeneratorManager::new, NameGeneratorManager::load, class_4284.field_45079), DATA_NAME);
        }
        return clientStorageCopy;
    }
}

